%{
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "a.h"
#include "Parser.h"


%}

%pure_parser

%union {
  double d;
  char s[1024];
  VARIABLE *v;
  VARLIST vl;
  EXPRLIST el;
  INTLIST il;
}

%token <d> NUM
%token <s> STRING
%token <s> NUMVAR
%token <s> STRINGVAR
%token <s> IDENTIFIER
%token <s> UNDEF

%token LTEQ GTEQ NEQ

%token End For Next
%token <s> Data
%token Input Del Dim Read

%token Gr Text Pr In Call Plot Hlin Vlin
%token Hgr2 Hgr Hcolor Hplot Draw Xdraw Htab Home
%token Rot Scale Shload Trace Notrace Normal Inverse Flash
%token Color Pop Vtab Himem Lomem Onerr Resume Recall
%token Store Speed Let Goto Run If Restore Amper

%token Gosub Return
%token <s> Rem
%token Stop On Wait Load Save

%token Def Poke Print Cont List Clear Get New

%token <s> Tab
%token To Fn Spc Then At Not Step

%token And Or
%token Sgn Int Abs Usr Fre Scrn
%token Pdl Pos Sqr Rnd Log Exp Cos Sin
%token Tan Atn Peek Len Str Val Asc Chr
%token Left Right Mid

%left Or And 
%right Not
%left '<' '>' LTEQ GTEQ NEQ '='
%left '+' '-'
%left '*' '/' '^'
%left UNARYMINUS

%type <d> expr
%type <s> string_expr
%type <s> print_exprs
%type <v> variable
%type <v> string_variable
%type <vl> var_list
%type <el> expr_list
%type <il> int_list

%%

line:
	statement
;

statement:
	UNDEF
	{
		fprintf(stderr,"LEX undefined char '%c' (0x%02x)\n",
			isprint(*$1) ? *$1 : '.',*$1);
	}
|
	End
	{
		THIS -> m_next_line = NULL;
	}
|
	For variable '=' expr To expr
	{
		NEXT *nx;

		for (nx = THIS -> m_nextbase; nx; nx = nx -> next)
			if (nx -> ln == THIS -> m_current_line)
			{
				THIS -> removelist(&THIS -> m_nextbase,nx);
				break;
			}
		if (!nx)
			nx = new NEXT; //(NEXT *)malloc(sizeof(NEXT));
		nx -> ln = THIS -> m_current_line;
		nx -> var = $2;
		$2 -> value = $4;
		nx -> tolimit = $6;
		nx -> step = 1;
		nx -> reline = THIS -> m_next_line;
		nx -> next = THIS -> m_nextbase;
		THIS -> m_nextbase = nx;
#ifdef DEBUG
fprintf(stderr,"%s\n",THIS -> m_current_line -> the_str);
#endif
	}
|
	For variable '=' expr To expr Step expr
	{
		NEXT *nx;

		for (nx = THIS -> m_nextbase; nx; nx = nx -> next)
			if (nx -> ln == THIS -> m_current_line)
			{
				THIS -> removelist(&THIS -> m_nextbase,nx);
				break;
			}
		if (!nx)
			nx = new NEXT; //(NEXT *)malloc(sizeof(NEXT));
		nx -> ln = THIS -> m_current_line;
		nx -> var = $2;
		$2 -> value = $4;
		nx -> tolimit = $6;
		nx -> step = $8;
		nx -> reline = THIS -> m_next_line;
		nx -> next = THIS -> m_nextbase;
		THIS -> m_nextbase = nx;
	}
|
	Next
	{
		NEXT *nx;

		nx = THIS -> m_nextbase;
		if (nx)
		{
		nx -> var -> value += nx -> step;
		if (nx -> step > 0)
		{
			if (nx -> var -> value > nx -> tolimit + nx -> step / 2)
			{
				THIS -> m_nextbase = nx -> next;
				delete nx; //free(nx);
			}
			else
			{
				THIS -> m_next_line = nx -> reline;
			}
		}
		else
		{
			if (nx -> var -> value < nx -> tolimit - nx -> step / 2)
			{
				THIS -> m_nextbase = nx -> next;
				delete nx; //free(nx);
			}
			else
			{
				THIS -> m_next_line = nx -> reline;
			}
		}
		} // if (nx)
	}
|
	Next var_list
	{
		NEXT *nx;
		int i;

		nx = THIS -> m_nextbase;
		i = 0; /* index in var_list */
		while (nx && i < $2.qty)
		{
			nx -> var -> value += nx -> step;
			if (nx -> step > 0)
			{
				if (nx -> var -> value > nx -> tolimit)
				{
					THIS -> m_nextbase = nx -> next;
					delete nx; //free(nx);
					nx = THIS -> m_nextbase;
				}
				else
				{
					THIS -> m_next_line = nx -> reline;
					nx = NULL;
				}
			}
			else
			{
				if (nx -> var -> value < nx -> tolimit)
				{
					THIS -> m_nextbase = nx -> next;
					delete nx; //free(nx);
					nx = THIS -> m_nextbase;
				}
				else
				{
					THIS -> m_next_line = nx -> reline;
					nx = NULL;
				}
			}
			i++; /* index in var_list */
		}
	}
|
	Data 
	{
		DATA *d;

		if (!THIS -> m_running)
		{
#ifdef DEBUGDATA
fprintf(stderr,"Data '%s'\n",$1);
#endif
			d = new DATA; //(DATA *)malloc(sizeof(DATA));
			d -> line = THIS -> m_current_line -> line;
			d -> data = new char[strlen($1) + 1]; //(char *)malloc(strlen($1) + 1);
			strcpy(d -> data,$1);
			THIS -> addlist(&THIS -> m_database,d);
		}
	}
|
	Input var_list
	{
		int i;

/* check for file ops */
		if (THIS -> m_running)
		for (i = 0; i < $2.qty; i++)
		{
#ifdef DEBUG
fprintf(stderr," * Input %d\n",i);
#endif
			if (THIS -> m_fil && THIS -> m_file_read)
			{
				THIS -> file_input($2.var[i] -> svalue,1024);
			}
			else
			{
				THIS -> inputstring($2.var[i] -> svalue,1024);
			}
			$2.var[i] -> value = atof($2.var[i] -> svalue);
		}
	}
|
	Input STRING ';' var_list
	{
		int i;

/* check for file ops */
		if (THIS -> m_running)
		{
//			THIS -> text_output($2);
			THIS -> pprintf($2);
			for (i = 0; i < $4.qty; i++)
			{
#ifdef DEBUG
fprintf(stderr," * Input %d\n",i);
#endif
				if (THIS -> m_fil && THIS -> m_file_read)
				{
					THIS -> file_input($4.var[i] -> svalue,1024);
				}
				else
				{
					THIS -> inputstring($4.var[i] -> svalue,1024);
				}
				$4.var[i] -> value = atof($4.var[i] -> svalue);
			}
		}
	}
|
	Del
|
	Dim var_list
	{
	}
|
	Read var_list
	{
		if (THIS -> m_running)
		{
			THIS -> read_data(&$2);
		}
	}
|
	Gr
|
	Text
|
	Call expr
|
	Htab expr
|
	Home
|
	Normal
|
	Inverse
|
	Flash
|
	Pop
	{
		SUB *sub;

		if (!THIS -> m_subbase)
		{
//			fprintf(stderr," *** pop without gosub\n");
			THIS -> m_next_line = THIS -> m_onerror;
		}
		else
		{
			sub = THIS -> m_subbase;
			THIS -> m_subbase = sub -> next;
			delete sub; //free(sub);
		}
	}
|
	Vtab expr
|
	Onerr Goto NUM
	{
		LINE *ln;

		THIS -> m_onerror = NULL;
		for (ln = THIS -> m_linebase; ln && !THIS -> m_onerror; ln = ln -> next)
			if (ln -> line == $3)
				THIS -> m_onerror = ln;
	}
|
	Speed expr
|
	Let variable '=' expr
	{
		$2 -> value = $4;
	}
|
	Let string_variable '=' string_expr
	{
		strcpy($2 -> svalue,$4);
	}
|
	variable '=' expr
	{
		$1 -> value = $3;
	}
|
	string_variable '=' string_expr
	{
		strcpy($1 -> svalue,$3);
	}
|
	Goto NUM
	{
		LINE *ln;

		for (ln = THIS -> m_linebase; ln; ln = ln -> next)
			if (ln -> line == (int)($2 + .01))
				break;
		if (!ln)
			fprintf(stderr,"GOTO undefined line number: %d\n",(int)($2 + .01));
		THIS -> m_next_line = ln;
	}
|
	If expr
	{
		if (!$2 && THIS -> m_running)
		{
			while (THIS -> m_next_line -> line == -1 && THIS -> m_next_line -> next)
				THIS -> m_next_line = THIS -> m_next_line -> next;
		}
	}
|
	Then statement
|
	Then NUM
	{
		LINE *ln;

		for (ln = THIS -> m_linebase; ln; ln = ln -> next)
			if (ln -> line == (int)($2 + .01))
				break;
		if (!ln)
			fprintf(stderr,"GOTO undefined line number: %d\n",(int)$2);
		THIS -> m_next_line = ln;
	}
|
	Restore
	{
		THIS -> m_current_data = THIS -> m_database;
		THIS -> m_dataptr = 0;
	}
|
	Restore NUM
	{
		DATA *d;

		for (d = THIS -> m_database; d; d = d -> next)
			if (d -> line == (int)($2 + 0.01))
				break;
		if (!d)
			fprintf(stderr,"RESTORE undefined line number: %d\n",(int)$2);
		THIS -> m_current_data = d ? d : THIS -> m_database;
		THIS -> m_dataptr = 0;
	}
|
	Gosub NUM
	{
		LINE *ln;
		SUB *sub;

		for (ln = THIS -> m_linebase; ln; ln = ln -> next)
			if (ln -> line == (int)$2)
				break;
		if (!ln)
			fprintf(stderr,"GOSUB undefined line number: %d\n",(int)$2);
		sub = new SUB; //(SUB *)malloc(sizeof(SUB));
		sub -> returnline = THIS -> m_next_line;
		sub -> next = THIS -> m_subbase;
		THIS -> m_subbase = sub;
		THIS -> m_next_line = ln;
	}
|
	Return
	{
		SUB *sub;

		if (!THIS -> m_subbase)
		{
//			fprintf(stderr," *** return without gosub\n");
			THIS -> m_next_line = THIS -> m_onerror;
		}
		else
		{
			sub = THIS -> m_subbase;
			THIS -> m_subbase = sub -> next;
			THIS -> m_next_line = sub -> returnline;
			delete sub; //free(sub);
		}
	}
|
	Rem
	{
//		fprintf(stderr,"Remark '%s'\n",$1);
	}
|
	Stop
|
	On expr Goto int_list
	{
		LINE *ln;

#ifdef DEBUG
fprintf(stderr," ON %d GOTO ...\n",(int)$2);
#endif
		if ( (int)$2 > 0 && (int)$2 <= $4.qty)
		{
			for (ln = THIS -> m_linebase; ln; ln = ln -> next)
				if (ln -> line == $4.values[(int)$2 - 1])
					break;
			if (!ln && THIS -> m_running)
				fprintf(stderr,"ON ... GOTO undefined line number: %d\n",(int)$2);
			THIS -> m_next_line = ln;
		}
		else
		{
			if (THIS -> m_running)
				fprintf(stderr,"ON ... GOTO outside bounds\n");
			THIS -> m_next_line = NULL;
		}
	}
|
	On expr Gosub int_list
	{
		LINE *ln;
		SUB *sub;

#ifdef DEBUG
fprintf(stderr," ON %d GOSUB ...\n",(int)$2);
#endif
		if ( (int)$2 > 0 && (int)$2 <= $4.qty)
		{
			for (ln = THIS -> m_linebase; ln; ln = ln -> next)
				if (ln -> line == $4.values[(int)$2 - 1])
					break;
			if (!ln && THIS -> m_running)
				fprintf(stderr,"ON ... GOTO undefined line number: %d\n",(int)$2);
			sub = new SUB; //(SUB *)malloc(sizeof(SUB));
			sub -> returnline = THIS -> m_next_line;
			sub -> next = THIS -> m_subbase;
			THIS -> m_subbase = sub;
			THIS -> m_next_line = ln;
		}
		else
		{
			if (THIS -> m_running)
				fprintf(stderr,"ON ... GOSUB outside bounds\n");
			THIS -> m_next_line = NULL;
		}
	}
|
	Def Fn IDENTIFIER '(' IDENTIFIER ')' '=' expr
	{
		FUNC *fn;
		char temp[1024];

		for (fn = THIS -> m_funcbase; fn; fn = fn -> next)
			if (!strcmp(fn -> name,$3))
				break;
		if (!fn)
		{
			fn = new FUNC; //(FUNC *)malloc(sizeof(FUNC));
			strcpy(fn -> name,$3);
			THIS -> addlist(&THIS -> m_funcbase,fn);
		}
		sprintf(temp,"%s",$5);
		fn -> placeholder = THIS -> reg_variable(temp,NULL);
		fn -> fnline = THIS -> m_current_line;
	}
|
	Poke expr ',' expr
	{
		THIS -> poke($2,$4);
	}
|
	Print
	{
		if (THIS -> m_running)
		{
			THIS -> pprintf("\n");
			THIS -> m_tab_pos = 0;
		}
	}
|
	Print print_exprs
	{
		if (THIS -> m_running)
		{
		char temp[1024];
		int i = 0;

		while (strlen($2 + i) > 40)
		{
			strncpy(temp,$2 + i,40);
			temp[40] = 0;
			THIS -> pprintf("%s\n",temp);
			i += 40;
		}
		THIS -> pprintf("%s\n",$2 + i);
		THIS -> m_tab_pos = 0;
		}
	}
|
	Print print_exprs ';'
	{
		if (THIS -> m_running)
		{
		char temp[1024];
		int i = 0;

		while (strlen($2 + i) > 40)
		{
			strncpy(temp,$2 + i,40);
			temp[40] = 0;
			THIS -> pprintf("%s\n",temp);
			i += 40;
		}
		THIS -> pprintf($2 + i);
		THIS -> m_tab_pos = strlen($2 + i);
		}
	}
|
	List int_list
|
	Get string_variable
	{
		if (THIS -> m_running)
		{
			if (THIS -> m_fil && THIS -> m_file_read)
			{
				fread($2 -> svalue,1,1,THIS -> m_fil);
			}
			else
			{
				THIS -> inputstring($2 -> svalue,1);
			}
			$2 -> svalue[1] = 0;
		}
	}



expr:
	NUM
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: NUM(%.1f)\n",$1);
#endif
		$$ = $1;
	}
|
	variable
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: variable(%s)\n",$1 -> name);
#endif
		$$ = $1 -> value;
	}
|
	'-' expr %prec UNARYMINUS
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: - expr\n");
#endif
		$$ = -$2;
	}
|
	expr '+' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr + expr\n");
#endif
		$$ = $1 + $3;
	}
|
	expr '-' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr - expr\n");
#endif
		$$ = $1 - $3;
	}
|
	expr '*' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr * expr\n");
#endif
		$$ = $1 * $3;
	}
|
	expr '/' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr / expr\n");
#endif
		$$ = $1 / $3;
	}
|
	expr '<' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr < expr\n");
#endif
		$$ = $1 < $3;
	}
|
	expr '>' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr > expr\n");
#endif
		$$ = $1 > $3;
	}
|
	expr LTEQ expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr <= expr\n");
#endif
		$$ = $1 <= $3;
	}
|
	expr GTEQ expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr >= expr\n");
#endif
		$$ = $1 >= $3;
	}
|
	expr NEQ expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr != expr\n");
#endif
		$$ = $1 != $3;
	}
|
	expr '=' expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr == expr\n");
#endif
		$$ = $1 == $3;
	}
|
	string_expr '<' string_expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: string_expr < string_expr\n");
#endif
		$$ = (strcmp($1,$3) < 0) ? 1 : 0;
	}
|
	string_expr '>' string_expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: string_expr > string_expr\n");
#endif
		$$ = (strcmp($1,$3) > 0) ? 1 : 0;
	}
|
	string_expr LTEQ string_expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: string_expr <= string_expr\n");
#endif
		$$ = (strcmp($1,$3) <= 0) ? 1 : 0;
	}
|
	string_expr GTEQ string_expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: string_expr >= string_expr\n");
#endif
		$$ = (strcmp($1,$3) >= 0) ? 1 : 0;
	}
|
	string_expr NEQ string_expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: string_expr != string_expr\n");
#endif
		$$ = strcmp($1,$3) ? 1 : 0;
	}
|
	string_expr '=' string_expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: string_expr == string_expr\n");
#endif
		$$ = !strcmp($1,$3);
	}
|
	expr Or expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr || expr\n");
#endif
		$$ = $1 || $3;
	}
|
	expr And expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: expr && expr\n");
#endif
		$$ = $1 && $3;
	}
|
	Abs '(' expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: ABS(expr)\n");
#endif
		if ($3 < 0)
			$$ = -$3;
		else
			$$ = $3;
	}
|
	Asc '(' string_expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: ASC(string_expr)\n");
#endif
		$$ = *$3;
	}
|
	Atn '(' expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: ATN(expr)\n");
#endif
		$$ = atan($3);
	}
|
	Int '(' expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: INT(expr)\n");
#endif
		$$ = (long)$3;
	}
|
	Val '(' string_expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: VAL(string_expr)\n");
#endif
		$$ = atof($3);
	}
|
	Rnd '(' expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: RND(expr)\n");
#endif
		$$ = (double)rand();
		$$ /= RAND_MAX;
	}
|
	'(' expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: (expr)\n");
#endif
		$$ = $2;
	}
|
	Not expr
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: NOT expr\n");
#endif
		$$ = !$2;
	}
|
	Fn IDENTIFIER '(' expr ')'
	{
		FUNC *fn;
		int i;
		char temp[1024];

#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: FN ... ( expr )\n");
#endif
fprintf(stderr,"LINE: '%s'\n",THIS -> m_the_str);
fprintf(stderr,"REST: '%s'\n",THIS -> m_the_str + THIS -> m_the_ptr);
		for (fn = THIS -> m_funcbase; fn; fn = fn -> next)
			if (!strcmp(fn -> name,$2))
				break;
		if (fn && fn -> fnline)
		{
fprintf(stderr,"Fn found\n");
fflush(stderr);
			fn -> placeholder -> fnvalue = fn -> placeholder -> value;
fprintf(stderr," ... 1 function line '%s'\n",fn -> fnline -> the_str);
fflush(stderr);
			fn -> placeholder -> value = $4;
fprintf(stderr," ... 2\n");
fflush(stderr);
			THIS -> m_placeholder = fn -> placeholder;
fprintf(stderr," ... 3\n");
fflush(stderr);
			i = 0;
#define FC fn -> fnline -> the_str[i]
			while (FC && FC != '=')
				i++;
fprintf(stderr," ... 4\n");
fflush(stderr);
			if (FC == '=')
			{
fprintf(stderr,"BEFORE: '%s'\n",THIS -> m_the_str);
				sprintf(temp,"*%s%s",fn -> fnline -> the_str + i + 1,THIS -> m_the_str + THIS -> m_the_ptr);
fprintf(stderr," ... 5\n");
fflush(stderr);
				strcpy(THIS -> m_the_str + THIS -> m_the_ptr,temp);
fprintf(stderr," ... 6\n");
fflush(stderr);
fprintf(stderr," AFTER: '%s'\n",THIS -> m_the_str);
			}
fprintf(stderr," ... 7\n");
fflush(stderr);
			$$ = 1;
		}
		else
		{
fprintf(stderr,"Fn not found\n");
fflush(stderr);
			fprintf(stderr,"Using Undefined Function '%s'\n",$2);
			THIS -> m_next_line = THIS -> m_onerror;
			$$ = 0;
		}
//fprintf(stderr,"REPL: '%s'\n",fn -> fnline -> the_str);
	}
|
	Len '(' string_expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: LEN(string_expr)\n");
#endif
		$$ = strlen($3);
	}
|
	Peek '(' expr ')'
	{
#ifdef DEBUGEXPR
fprintf(stderr," *-* expr: PEEK(expr)\n");
#endif
		$$ = THIS -> peek($3);
#ifdef DEBUGMEM
fprintf(stderr,"peek(%d) returns %d\n",(int)$3,(int)$$);
#endif
	}
|
	Fre '(' expr ')'
	{
		$$ = 32000;
	}

string_expr:
	STRING
|
	string_variable
	{
		strcpy($$,$1 -> svalue);
	}
|
	Mid '(' string_expr ',' expr ')'
	{
		if ($5 <= strlen($3))
		{
			strcpy($$,$3 + (int)$5 - 1);
		}
		else
			*$$ = 0;
	}
|
	Mid '(' string_expr ',' expr ',' expr ')'
	{
		if ($5 <= strlen($3))
		{
			strcpy($$,$3 + (int)$5 - 1);
			$$[ (int)$7] = 0;
		}
		else
			*$$ = 0;
	}
|
	Left '(' string_expr ',' expr ')'
	{
		if ($5 > 0)
		{
			strncpy($$,$3, (int)$5);
			$$[(int)$5] = 0;
		}
	}
|
	Right '(' string_expr ',' expr ')'
	{
		if (strlen($3) > $5)
			strcpy($$,$3 + strlen($3) - (int)($5 + 0.01));
		else
			strcpy($$,$3);
	}
|
	Chr '(' expr ')'
	{
		*$$ = (char)$3;
		$$[1] = 0;
	}
|
	string_expr '+' string_expr
	{
		sprintf($$,"%s%s",$1,$3);
	}
|
	Str '(' expr ')'
	{
		sprintf($$,"%f",$3);
		while ($$[strlen($$) - 1] == '0')
			$$[strlen($$) - 1] = 0;
		if ($$[strlen($$) - 1] == '.')
			$$[strlen($$) - 1] = 0;
	}
|
	Tab '(' expr ')'
	{
		*$$ = 0;
		while (THIS -> m_tab_pos < $3)
		{
			strcat($$," ");
			THIS -> m_tab_pos++;
		}
	}
|
	Spc '(' expr ')'
	{
		int i;

		*$$ = 0;
		for (i = 0; i < $3; i++)
			strcat($$," ");
	}
|
	'(' string_expr ')'
	{
		$$ = $2;
	}

int_list:
	NUM
	{
		$$.qty = 0;
		$$.values[$$.qty++] = (long)$1;
	}
|
	int_list ',' NUM
	{
		$$ = $1;
		$$.values[$$.qty++] = (long)$3;
	}

var_list:
	variable
	{
		$$.qty = 0;
		$$.var[$$.qty++] = $1;
	}
|
	string_variable
	{
		$$.qty = 0;
		$$.var[$$.qty++] = $1;
	}
|
	var_list ',' variable
	{
		$$ = $1;
		$$.var[$$.qty++] = $3;
	}
|
	var_list ',' string_variable
	{
		$$ = $1;
		$$.var[$$.qty++] = $3;
	}

variable:
	NUMVAR
	{
		$$ = THIS -> reg_variable($1,NULL);
	}
|
	IDENTIFIER
	{
		$$ = THIS -> reg_variable($1,NULL);
	}
|
	NUMVAR '(' expr_list ')'
	{
		$$ = THIS -> reg_variable($1,&$3);
	}
|
	IDENTIFIER '(' expr_list ')'
	{
		$$ = THIS -> reg_variable($1,&$3);
	}

string_variable:
	STRINGVAR 
	{
		$$ = THIS -> reg_variable($1,NULL);
	}
|
	STRINGVAR '(' expr_list ')'
	{
		$$ = THIS -> reg_variable($1,&$3);
	}

expr_list:
	expr
	{
		$$.qty = 0;
		$$.values[$$.qty++] = $1;
	}
|
	expr_list ',' expr
	{
		$$ = $1;
		$$.values[$$.qty++] = $3;
	}

print_exprs:
	expr
	{
		char slask[256];

		sprintf(slask,"%f",$1);
		while (slask[strlen(slask) - 1] == '0')
			slask[strlen(slask) - 1] = 0;
		if (slask[strlen(slask) - 1] == '.')
			slask[strlen(slask) - 1] = 0;
		strcpy($$,slask);
		THIS -> m_tab_pos = strlen($$);
	}
|
	string_expr
	{
		strcpy($$,$1);
		THIS -> m_tab_pos = strlen($$);
	}
|
	print_exprs print_separator expr
	{
		char slask[256];

		sprintf(slask,"%f",$3);
		while (slask[strlen(slask) - 1] == '0')
			slask[strlen(slask) - 1] = 0;
		if (slask[strlen(slask) - 1] == '.')
			slask[strlen(slask) - 1] = 0;
		sprintf($$,"%s%s",$1,slask);
		THIS -> m_tab_pos = strlen($$);
	}
|
	print_exprs print_separator string_expr
	{
		sprintf($$,"%s%s",$1,$3);
		THIS -> m_tab_pos = strlen($$);
	}

print_separator:
|
	';'
|
	','

%%

void yyerror(void *parser,char *s)
{
	int i;

	if (THIS -> m_pclParserIO)
	{
		THIS -> pprintf("******** error in parser, program file '");
		THIS -> pprintf("%s'\n", THIS -> m_programname );
		THIS -> pprintf("%s\n", THIS -> m_the_str);
		for (i = 0; i < THIS -> m_the_ptr; i++)
			THIS -> pprintf(" ");
		THIS -> pprintf("^ %s\n", s);
		THIS -> pprintf("******** program aborted ********\n");
	}
	fprintf(stderr,"Error in '%s':\n",THIS -> m_programname);
	fprintf(stderr,"%s\n",THIS -> m_the_str);
	for (i = 0; i < THIS -> m_the_ptr; i++)
		fprintf(stderr," ");
	fprintf(stderr,"^ %s\n",s);
	fflush(stderr);
	if (!THIS -> m_pclParserIO)
	{
//		exit(-1);
	}
}

